function [obj] = bm_process_parm_list_new()
% create list object of bm_process_parm.
% [IN]
%    [obj] = brain_process_parm_list_new;
% [OUT]
%    obj : brain_process_parm_list object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

obj = struct;

% set class type
obj.class_type = 'brain_process_parm_list';

%
% --- Member intialize
%

const = define_bm_edit_app;
type = const.parm_type;

% make all parameters
obj.surf_smooth_parameter = ...
    bm_process_parm_create_parameter(type.SURF_SMOOTH_PARM);
obj.surf_smooth_expand_parameter = ...
    bm_process_parm_create_parameter(type.SURF_SMOOTH_EXPAND_PARM);
obj.surf_to_filled_mask_parameter = ...
    bm_process_parm_create_parameter(type.SURF_TO_FILLED_MASK_PARM);
obj.separate_surf_parameter = ...
    bm_process_parm_create_parameter(type.SEPARATE_SURF_PARM);
obj.combine_surf_parameter = ...
    bm_process_parm_create_parameter(type.COMBINE_SURF_PARM);
obj.close_surf_parameter = ...
    bm_process_parm_create_parameter(type.CLOSE_SURF_PARM);
obj.morphology_operation_parameter = ...
    bm_process_parm_create_parameter(type.MORPHOLOGY_OPERATION_PARM);
obj.surf_extract_parameter = ...
    bm_process_parm_create_parameter(type.SURF_EXTRACT_PARM);

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
