function [obj] = bm_manager_rename_model(obj, index, new_name)
% rename brain model
% [USAGE]
%    [obj] = bm_manager_rename_model(<obj>, <index>, <new_name>);
% [IN]
%         obj : bm_manager object
%       index : bm_list index
%    new_name : new model name
%
% [OUT]
%    obj : bm_manager object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('index', 'var'), error('index is a required parameter.'); end
if ~exist('new_name', 'var'), error('new_name is a required parameter.'); end

%
% --- Main Procedure
%
brain_data_cell = bm_list_get_brain_model(obj.bm_list, index);

for k=1:length(brain_data_cell)
    brain_data = brain_data_cell{k};
    old_name = brain_data_get_model_name(brain_data);

    % Rename
    brain_data = brain_data_set_model_name(brain_data, new_name);

    % write rename history
    history_str = ['renamed from ' old_name ' to ' new_name];
    brain_data  = brain_data_add_history_item(brain_data, history_str);
    % regist
    obj.bm_list = bm_list_overwrite_model(obj.bm_list, ...
                                             brain_data, ...
                                             index(k));
end

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
