function [obj, new_index] = bm_manager_process_brain(obj, parm_type, index)
% process brain and regist new data.
% [USAGE]
%    [obj, new_index] = 
%        bm_manager_process_brain(<obj>, <parm_type>, <index>);
% [IN]
%          obj : bm_manager object
%    parm_type : processing type
%        index : index of process brain
% [OUT]
%          obj : bm_manager object
%    new_index : index after processing
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~strcmp(obj.class_type, 'bm_manager')
    error('class type is invalid.');
end
if ~exist('parm_type', 'var');
    error('parm_type is a required parameter.');
end
if ~exist('index', 'var'), error('index is a required parameter.'); end

%
% --- Main Procedure
%
const = define_bm_edit_app;
type = const.parm_type;

brain_data_cell = bm_list_get_brain_model(obj.bm_list, index);
proc_parm = bm_process_parm_list_get_parameter(obj.parm_list, parm_type);

switch(parm_type)
    case type.COMBINE_SURF_PARM
        % create model from n to 1.
        new_model_cell = bm_processor_process(obj.processor, ...
                                                brain_data_cell, ...
                                                parm_type, ...
                                                proc_parm);
        model_name = 'combined model';
        new_model_cell{1} = brain_data_set_model_name(new_model_cell{1},...
                                                    model_name);
        [obj.bm_list, new_index] = bm_list_add_model(...
                                                    obj.bm_list, ...
                                                    new_model_cell{1});
    case type.SEPARATE_SURF_PARM
        % create model from 1 to n.
        % outer loop is for n-models are selected.
        for k=1:length(brain_data_cell)
            brain_data = brain_data_cell{k};
            new_model_cell = bm_processor_process(obj.processor, ...
                                                    {brain_data}, ...
                                                    parm_type, ...
                                                    proc_parm);
            % inner loop is for n-models created from 1 model.
            for j=1:length(new_model_cell)
                old_name = brain_data_get_model_name(brain_data);
                new_name = ['separated model', num2str(j), ' from ' old_name];
                new_model_cell{j} = brain_data_set_model_name(...
                                                    new_model_cell{j}, ...
                                                    new_name);
                [obj.bm_list, new_index] = bm_list_add_model(...
                                                    obj.bm_list, ...
                                                    new_model_cell{j});
            end
        end
    otherwise
        % create model from 1 to n.
        % outer loop is for n-models are selected.
        for k=1:length(brain_data_cell)
            brain_data = brain_data_cell{k};
            new_model_cell = bm_processor_process(obj.processor, ...
                                                    {brain_data}, ...
                                                    parm_type, ...
                                                    proc_parm);
            % inner loop is for n-models created from 1 model.
            for j=1:length(new_model_cell)
                old_name = brain_data_get_model_name(brain_data);
                new_model_cell{j} = brain_data_set_model_name(...
                                                    new_model_cell{j}, ...
                                                    old_name);
                [obj.bm_list, new_index] = bm_list_add_model(...
                                                    obj.bm_list, ...
                                                    new_model_cell{j});
            end
        end
end
