function [obj] = bm_manager_new()
% create brain model controller.
% [USAGE]
%    [obj] = bm_manager_new();
% [IN]
%    none
% [OUT]
%    obj : bm_manager object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

obj = struct;

% set class type
obj.class_type = 'bm_manager';

%
% --- Member initialize
%

% brain model list
obj.bm_list = bm_list_new;

% process parameter list
obj.parm_list  = bm_process_parm_list_new;

% processor
obj.processor = bm_processor_new;

% analyze information
obj.analyze_info = [];

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
