function [obj, result] = bm_manager_export_file(obj, file_type, out_file, index)
% export brain model
% [USAGE]
%    [obj, result] = bm_manager_export_file(<obj>, <file_type>, <out_file>);
% [IN]
%          obj : bm_manager object
%    file_type : export file type
%     out_file : export file name(fullpath)
%        index : selected model index
% [OUT]
%       obj : bm_manager object
%    result : brain model export result.
%             (SUCCESS or FAILURE)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~strcmp(obj.class_type, 'bm_manager')
    error('class type is invalid.');
end
if ~exist('file_type', 'var')
    error('file_type is a required parameter.');
end
if ~exist('out_file', 'var')
    error('out_file is a required parameter.');
end
if ~exist('index', 'var')
    error('index is a required parameter.');
end
%
% --- Main Procedure
%
app_const = define_bm_edit_app;

% listup export data
brain_data_cell = bm_list_get_brain_model(obj.bm_list, index);
export_bm_list = bm_list_new;
for k=1:length(brain_data_cell)
    export_bm_list = ...
            bm_list_add_model(export_bm_list, brain_data_cell{k});
end

% export data
exporter = bm_fileio_new;
exporter = bm_fileio_set_bm_list(exporter, export_bm_list);
[exporter, result] = bm_fileio_export_file(exporter, ...
                                            file_type, ...
                                            out_file , ...
                                            obj.analyze_info);
