function [V_cell, F_cell, xx_cell, model_name_cell, conduct_cell] = ...
                bm_fileio_read_curry_file(file_name, analyze_info)
% read curry file.
% [USAGE]
%    [V_cell, F_cell, xx_cell] = ...
%                 bm_fileio_read_curry_file(<file_name>, <analyze_info>);
% [IN]
%       file_name : full path head file name(.head.mat)
%    analyze_info : analyze information
% [OUT]
%             V_cell : cell array of vertex
%             F_cell : cell array of face
%            xx_cell : cell array of normal vector
%    model_name_cell : cell array of model name
%       conduct_cell : cell array of conductivity value
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('file_name', 'var')
    error('file_name is a required parameter.');
end
if ~exist('analyze_info', 'var')
    error('analyze_info is a required parameter.');
end
if exist(file_name, 'file') ~= 2
    error(['specified head file does not exist : ' file_name]);
end

%
% --- Main Procedure
%
const = define_bm_edit_app;

V_cell = cell(0);
F_cell = cell(0);
xx_cell = cell(0);
model_name_cell = cell(0);
conduct_cell = cell(0);

analyze_file = vb_analyze_info_get_file_prefix(analyze_info);

[F_cell{1}, V_cell{1}, xx_cell{1}] = ...
                        vb_read_curry_surface(file_name, analyze_file);

model_name_cell{1} = 'brain model1';
conduct_cell{1} = const.DEFAULT_CONDUCTIVITY;
