function [view_obj] = bm_edit_app_view_update(...
                                    view_obj, brain_app, ...
                                    func_h, view_setting_obj)
% bm_edit_app_view screen update
% [USAGE]
%    [view_obj] = bm_edit_app_view_update(...
%                            <view_obj>, <brain_app>, <view_setting_obj>);
% [IN]
%            view_obj : bm_edit_app_view object
%              func_h : function handle to get display factor.
%    view_setting_obj : view setting object
% [OUT]
%    view_obj : updated view object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('view_obj', 'var'), error('view_obj is a required parameter.'); end
if ~exist('brain_app', 'var')
    error('brain_app is a required parameter.');
end
if ~exist('func_h', 'var')
    error('func_h is a required parameter.');
end
if ~exist('view_setting_obj', 'var')
    error('view_setting_obj is a required parameter.');
end

%
% --- Main Procedure
%

% call subclass update function

switch(view_obj.class_type)
    case 'bm_edit_app_view2d'
        [view_obj] = ...
        bm_edit_app_view2d_update(view_obj, brain_app, func_h, view_setting_obj);
    case 'bm_edit_app_view3d'
        [view_obj] = ...
            bm_edit_app_view3d_update(view_obj, brain_app, func_h, view_setting_obj);
end

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
