function [view2d] = bm_edit_app_view2d_update(view2d, brain_app, ...
                                              func_h, view_setting2d)
% 2d view update.
% [USAGE]
%    [view2d] = ...
%        bm_edit_app_view2d_update(<view2d>, <func_h>, <brain_app>, <view_setting2d>);
% [IN]
%              view2d : bm_edit_app_view2d object
%           brain_app : brain application object
%              func_h : function handle to get display factor
%    view_setting_2d  : view_setting_2d object
% [OUT]
%    bm_edit_app_view2d object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('view2d', 'var'), error('view2d is a required parameter.'); end
if ~exist('brain_app', 'var')
    error('brain_app is a required parameter.');
end
if ~exist('func_h', 'var'), error('func_h is a required parameter.'); end
if ~exist('view_setting2d', 'var')
    error('view_setting2d is a required parameter.');
end

%
% --- Main Procedure
%

% get display data
display_factor = feval(func_h, brain_app);

% update display(brain)
view2d = ...
    bm_edit_app_view2d_display_brain(view2d, display_factor, view_setting2d);


%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
