function [obj] = bm_edit_app_update_model_status_listbox(obj)
% update brain model status listbox
% [USAGE]
%    [obj] = bm_edit_app_update_model_status_listbox(<obj>);
% [IN]
%    obj : bm_edit_app object
% [OUT]
%    obj : bm_edit_app object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~strcmp(obj.class_type, 'bm_edit_app')
    error('class type is invalid.');
end

%
% --- Main Procedure
%
H = guihandles(obj.h);

all_index = bm_manager_get_bm_list_index(obj.bmm);
selected_index = get(H.brain_model_list_listbox, 'Value');

if length(selected_index) == 1 && ~isempty(all_index)
    %
    % Make string of brain model status
    %
    info_cell = bm_manager_get_model_info(obj.bmm, selected_index);
    info = info_cell{1};
    status_str = sprintf('model name : %s\ntype       : %s\n', ...
                                                info.model_name, ...
                                                info.class_type);
    % add surface close status
    if isfield(info, 'surf_close')
        if info.surf_close == true
            surf_str = 'surface    : closed.';
        else
            surf_str = 'surface    : not closed.';
        end
        status_str = [status_str, surf_str];
    end
    % conductivity
    conductivity_str = num2str(info_cell{1}.conductivity);
else
    status_str = [];
    conductivity_str = [];
end

set(H.brain_model_status_edit, 'String', status_str);
set(H.conductivity_edit, 'String', conductivity_str);

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
