function [obj] = bm_edit_app_update_history_listbox(obj)
% update history listbox
% [USAGE]
%    [obj] = bm_edit_app_update_history_listbox(<obj>);
% [IN]
%    obj : bm_edit_app object
% [OUT]
%    obj : bm_edit_app object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~strcmp(obj.class_type, 'bm_edit_app')
    error('class type is invalid.');
end

%
% --- Main Procedure
%
H = guihandles(obj.h);

selected_index = get(H.brain_model_list_listbox, 'value');
all_index = bm_manager_get_bm_list_index(obj.bmm);

if length(selected_index) == 1 && ~isempty(all_index)
    [description_cell, parm_cell] = bm_manager_get_history( obj.bmm, ...
                                                            selected_index);
    % Set history to history_listbox
    set(H.history_listbox, 'String', description_cell);

    % Set history parameter to execution parameter window
    index_no = get(H.history_listbox, 'value');
    parm = parm_cell{index_no};
    if ~isempty(parm)
        parm_str = vb_struct2str(parm);
    else
        parm_str = [];
    end
    % history list, history detail enable on
    set(H.history_edit,    'String', parm_str);
    set(H.history_listbox, 'Enable', 'on');
    set(H.history_edit,    'Enable', 'on');
else
    % history list, history detail enable off
    set(H.history_listbox, 'String', '');
    set(H.history_edit,    'String', '');
    set(H.history_listbox, 'Enable', 'off');
    set(H.history_edit,    'Enable', 'off');
end

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
