function [parm_type] = bm_edit_app_menu_to_parm_type(obj, menu_handle)
% get parm_type from menu_handle
% [USAGE]
%    [parm_type] = bm_edit_app_menu_to_parm_type(<obj>, <menu_handle>);
% [IN]
%            obj : bm_edit_app object
%    menu_handle : menu handle
% [OUT]
%    parm_type : parm type
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('menu_handle', 'var')
    error('menu_handle is a required parameter.');
end

%
% --- Main Procedure
%
index = find(obj.menu_parm_map(:, 1) == menu_handle);
if isempty(index)
    error('brain_app.menu_parm_map is invalid.');
end
parm_type = obj.menu_parm_map(index, 2);
