function obj = bm_edit_app_close_all_view(obj)
% close view
% [USAGE]
%    obj = bm_edit_app_close_all_view(<obj>);
% [IN]
%    obj : bm_edit_app object
% [OUT]
%    obj : bm_edit_app object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end

%
% --- Main Procedure
%
if ~isempty(obj.view2d) && bm_edit_app_view_is_opening(obj.view2d)
    bm_edit_app_view_close(obj.view2d);
    obj.view2d = [];
end

if ~isempty(obj.view3d) && bm_edit_app_view_is_opening(obj.view3d)
    bm_edit_app_view_close(obj.view3d);
    obj.view3d = [];
end

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
