function bayes_parm_editor_callback(fig, hObj)
% callback function for bayes_parm editor gui.
% [USAGE]
%    bayes_parm_editor_callback(<fig>, <hObj>);
% [IN]
%     fig : figure handle of fmri gui.
%    hObj : component handle.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure is specified.');
end
if ~exist('hObj', 'var')
    error('hObj is a required parameter.');
end

%
% --- Main Procedure
%
global vbmeg_inst;
define = vbmeg_inst.const;

% load data(@see pa_fmri_create)
data = guidata(fig);
H = data.H;

meg_info = bayes_parm_editor(data.main_obj,'get_megfile_info');

switch( hObj )
 case H.Rfilt_edit
  Rfilt = str2num(get(H.Rfilt_edit,'String'));
  if ~isempty(Rfilt), 
    if Rfilt<0, Rfilt = 0; end
    bayes_parm.Rfilt = Rfilt*1e-3;
    bayes_parm.Rfilt_global = Rfilt*1e-3;
    bayes_parm_editor(data.main_obj,'merge_bayes_parm',bayes_parm);
  end
  
 case H.reduce_edit
  reduce = str2num(get(H.reduce_edit,'String'));
  if ~isempty(reduce), 
    if reduce<0.001, reduce = 0.001; 
    elseif reduce>1, reduce = 1; end
    bayes_parm.reduce = reduce;
    bayes_parm.reduce_global = reduce;
    bayes_parm_editor(data.main_obj,'merge_bayes_parm',bayes_parm);
  end
  
 case H.duration_check_push
  % Display durations
  [start_pos, end_pos, err] = get_interval(H,meg_info);
  if err
    return;
  end

  time_window_string = [num2str(start_pos, '%-8.2f'),...
                      repmat(' - ', length(start_pos), 1),...
                      num2str(end_pos, '%-8.2f')];
  % set to listbox
  set(H.duration_listbox, 'String', time_window_string);
  % set listbox line
  set(H.duration_listbox, 'Value', 1);
end

function [start_pos, end_pos, err] = get_interval(H,meg_info)
% This function gets small window start points and end points.
% [IN]
%      H : GUI component handle.
% [OUT]
%      start_pos : time window start positions
%      end_pos   : time window end positions
%      err       : return true when time window is invalid.

start_pos = [];
end_pos = [];
err = false;

sample_freq = vb_meginfo_get_sampling_frequency(meg_info);

if get(H.time_shift_manual_radiobutton, 'Value')
  % manual Shift
  command = ['[' get(H.time_shift_start_pos_edit, 'String') ']']; 
  start_pos = eval(command);
  start_pos = start_pos(:);
  command = ['[' get(H.time_shift_end_pos_edit, 'String') ']']; 
  end_pos = eval(command);
  end_pos = end_pos(:);

  if length(start_pos) ~= length(end_pos)
    errordlg('Check Start positions and End positions.', 'Error');
    err = true;
  end
else
  % equally Shift
  window_size = str2double(...
      get(H.time_shift_window_size_edit, 'String'));
  shift_length = str2double(...
      get(H.time_shift_shift_length_edit, 'String'));
  begin = str2double( ...
      get(H.whole_time_window_from_edit, 'String'));
  last  = str2double(...
      get(H.whole_time_window_to_edit, 'String'));

  st = clock;
  w_start_pos = begin;
  w_end_pos = 0;  
  one_time_point_sec = vb_numsamp_to_time(1, sample_freq);
  while( (w_end_pos <= last) && (w_start_pos < last) )
    loop_out = false;
    w_end_pos = w_start_pos + window_size - one_time_point_sec;
    if w_end_pos >= last
      w_end_pos = last;
      loop_out = true;
    end

    % add small window start_pos, end_pos
    start_pos = [start_pos; w_start_pos];
    end_pos = [end_pos; w_end_pos];

    w_start_pos = w_start_pos + shift_length;
    if loop_out || etime(clock, st) >= 3
      break;
    end
  end
end
