function [fig] = bayes_parm_basic_init(main_obj, proj_root, bayes_parm)
% creates bayes basic parameter gui.
% [USAGE]
%    bayes_parm_basic_init(<main_obj>[, proj_root][, bayes_parm]);
% [IN]
%      main_obj : main object of bayes_parm_editor
%     proj_root : project root directory
%    bayes_parm : bayes parameter.
% [OUT]
%    fig : figure handle of bayes basic parameter gui.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('main_obj', 'var'), error('main_obj is a required parameter.'); end
if ~exist('proj_root', 'var') || isempty(proj_root)
    proj_root = [];
end
if ~exist('bayes_parm', 'var') || isempty(bayes_parm)
    bayes_parm = vb_set_bayes_parm;
end

%
% --- Main Procedure
%
fig = openfig('bayes_parm_editor.fig');
H = guihandles(fig);
H.figure = fig;

data = struct;
data.H = H;
data.main_obj = main_obj;

% save data
guidata(fig, data);

set(H.project_root_edit, 'String', proj_root);
