function [adv_fig] = bayes_parm_advanced_init(main_obj, bayes_parm)
% create bayes advanced parmameter gui.
% [USAGE]
%    [adv_fig] = bayes_parm_advanced_init(<main_obj>, <bayes_parm>);
% [IN]
%       main_obj : bayes_parm_editor main object.
%     bayes_parm : to be set bayes parameter.
% [OUT]
%    adv_fig : figrure handle of bayes advanced parameter gui.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('main_obj', 'var') || isempty(main_obj) || ~ishandle(main_obj)
    error('main_obj is invalid.');
end
if ~exist('bayes_parm', 'var'),
    error('bayes_parm is a required parameter.');
end

%
% --- Main Procedure
%

adv_fig = openfig('bayes_parm_editor_advanced.fig');
H = guihandles(adv_fig);
H.figure = adv_fig;

data = struct;
data.H = H;
data.main_obj = main_obj; % main object of bayes_parm_editor

% save data
guidata(adv_fig, data);

% View update
bayes_parm_advanced_gui(adv_fig, 'set_parm', bayes_parm);
