function bayes_parm_advanced_close(fig, ok_close)
% close bayes advanced parameter gui.
% [USAGE]
%    bayes_parm_advanced_close(<fig>[, ok_close]);
% [IN]
%          fig : figure handle of bayes advaced parameter gui.
%     ok_close : true means gui closed by ok button
%                false means gui close by cancel button(default)
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig)
    error('fig is a required parameter.');
end
if ~exist('ok_close', 'var')
    ok_close = false;
end
    
%
% --- Main Procedure
%
if ishandle(fig)
    % load data(@see bayes_parm_advanced_init)
    data = guidata(fig);
    if ok_close
        [bayes_parm, a0_act_auto] = ...
            bayes_parm_advanced_gui(data.H.figure, 'get_parm');
        bayes_parm_editor(data.main_obj, 'set_a0_act_auto', a0_act_auto);
        bayes_parm_editor(data.main_obj, 'merge_bayes_parm', bayes_parm);
    end
    delete(data.H.figure);
end
