function vb_parm_editor_gui_callback(fig, hObj)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

data = guidata(fig);

H = data.H;

idx = get(H.contents_listbox, 'Value');
current_variable_name = data.accessor{idx};
set(H.error_window_edit, 'String', '');
switch(hObj)
    case H.contents_listbox
        % set selected variable name to gui
        set(H.value_name_edit, 'String', [current_variable_name ' =']);

        % get selected variable and convert it to evaluative string
        val = eval(['data.' current_variable_name]);
        [evalstr, available,type_dim] = vb_var2evalstr(val);

        % set Variable type to gui
        set(H.type_dim_text, 'String', type_dim);
 
        % gui status change(editable or not)
        if available
            set(H.value_edit, 'String', evalstr);
            set(H.value_edit, 'Style', 'edit');   % These 2lines automatically
            set(H.value_edit, 'Style', 'listbox');% adjust display status.
            set_edit_state(H, 'editable');
            % If listbox is double clicked, change mode to editting
            if strcmpi(get(fig, 'SelectionType'), 'open')
                set_edit_state(H, 'editting');
            end
        else
            set(H.error_window_edit, 'String', 'structure or over 3D variable cannot be edited.');
            set_edit_state(H, 'uneditable');
        end
    case H.show_file_parameter_checkbox
        data.show_file_parameters = get(hObj, 'Value');
        % create listbox string and data accessor
        data = vb_parm_editor_gui_data_make(data);
        guidata(fig, data);
        % update
        set(H.contents_listbox, 'String', data.listbox_strings);
        set(H.contents_listbox, 'Value', 1');
    case H.case_sensitive_checkbox
        data.case_sensitive = get(hObj, 'Value');
        % create listbox string and data accessor
        data = vb_parm_editor_gui_data_make(data);
        guidata(fig, data);
        % update
        set(H.contents_listbox, 'String', data.listbox_strings);
        set(H.contents_listbox, 'Value', 1');
    case H.search_text_edit
        search_name = get(hObj, 'String');
        if isempty(search_name)
            search_name = '*';
        end
        % prepare for use regexp
        % meta character: '.' is cancelled out.
        search_name = strrep(search_name, '.', '\.');
        % meta character: '$' is cancelled out.
        search_name = strrep(search_name, '$', '\$');
        % meta character: '*' is replaced to '.*'
        search_name = strrep(search_name, '*', '.*');
        data.search_name = search_name;
        % create listbox string and data accessor
        data = vb_parm_editor_gui_data_make(data);
        guidata(fig, data);
        % update
        set(H.contents_listbox, 'String', data.listbox_strings);
        set(H.contents_listbox, 'Value', 1');
    case H.value_edit
        % If listbox is double clicked, change mode to editting
        if strcmpi(get(fig, 'SelectionType'), 'open')
            set_edit_state(H, 'editting');
        end
    case H.value_edit_push
        set_edit_state(H, 'editting');
    case H.value_apply_push
        try
            % get string list from editbox(devided by linefeed on editbox)
            str = get(H.value_edit, 'String');
            tmp = '';
            error_line = [];
            % concatenate string list into one line.
            % add \n to each line.(replicate for execute eval function)
            for k=1:size(str, 1)
                % inspect line
                line = sprintf('%s\n', deblank(str(k, :)));
                ix = strfind(line, '$');
                Ndollar = length(ix);
                err = false;
                if (mod(Ndollar, 2) ~= 0)
                    err = true;
                end
                if Ndollar ~= 0 && (mod(Ndollar, 2) == 0 )
                    for k=1:(Ndollar/2)
                        if ix(2*k-1)+1 == (ix(2*k))
                            % found '$$'
                            err = true;
                        end
                    end
                end
                if err
                    error_line = [error_line, line];
                end
                tmp = [tmp, line];
            end
            if ~isempty(error_line)
                error(sprintf('\nIncomplete variables were found.($VAL$) : \n%s', error_line));
            end
            % get value
            val = eval(tmp);
            base = eval(['data.' current_variable_name]);
            val_info = whos('val');
            base_info = whos('base');
            % Type check
            if ~strcmp(val_info.class, base_info.class)
                res = questdlg('Variable type will change. Are you sure?',...
                               'Confirm', 'Yes', 'No', 'No');
                if strcmpi(res, 'no'), return; end
            end
            % Update variable and save data
            command = ['data.', current_variable_name '=val;'];
            eval(command);
            data.modified = true;
            guidata(fig, data);
            set_edit_state(H, 'editable');
        catch
            % evaluate failed
            set(H.value_edit, 'BackgroundColor', [0.80, 0.2, 0.2]);
            set(H.error_window_edit, 'String', lasterr);
        end
    case H.value_cancel_push
        vb_parm_editor_gui_callback(fig, H.contents_listbox);
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %   Close gui
    case H.cancel_push
        vb_parm_editor_gui_closereq(fig);
    case H.save_push
        data.cancel_flag = false;
        guidata(fig, data);
        vb_parm_editor_gui_closereq(fig, false);
        
end

function set_edit_state(H, state)

switch(state)
    case 'editting'
        set(H.value_edit, 'Style', 'edit');
        set(H.value_edit, 'BackgroundColor', [0.3 0.7 0.6]); %
        set(H.value_edit, 'ForegroundColor', [1 1 1]); %white
        set(H.value_edit_push, 'Enable', 'off');
        set(H.value_apply_push, 'Enable', 'on');
    case 'editable'
        set(H.value_edit, 'Style', 'listbox', 'Enable', 'on', 'Value', []);
        set(H.value_edit, 'Listboxtop', 1);
        set(H.value_edit, 'BackgroundColor', [1 1 1]); %white
        set(H.value_edit, 'ForegroundColor', [0 0 0]); %black
        set(H.value_edit_push, 'Enable', 'on');
        set(H.value_apply_push, 'Enable', 'off');
    case 'uneditable'
        set(H.value_edit, 'Style', 'listbox', 'Enable', 'Inactive', 'Value', []);
        set(H.value_edit, 'BackgroundColor', [1 1 1]);
        set(H.value_edit_push, 'Enable', 'off');
        set(H.value_apply_push, 'Enable', 'off');
        set(H.value_edit, 'String', '');
end
