function [h, edit_h] = vb_text_area(title, text)
% Show text by using editbox
% [USAGE]
%    h = vb_text_area(<title><,text>);
% [IN]
%    title : figure title
%     text : string to be shown
% [OUT]
%         h : figure handle
%    edit_h : editbox component handle
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('title', 'var')
    error('title is a required parameter.');
end
if ~exist('text', 'var')
    error('text is a required parameter.');
end

%
% --- Main Procedure
%
h = openfig('vb_text_area.fig');
H = guihandles(h);

edit_h = H.text_edit;

set(h, 'Name', title);
set(edit_h, 'String', text);
