function obj = vb_batch_variable_table_remove_column(obj, column_name)
% remove column
% [USAGE]
%    obj = vb_batch_variable_add_column(<obj>, <column_name>);
% [IN]
%            obj : vb_batch_variable_table object
%    column_name : remove column name such as '$SUBJECT$' [STRING]
% [OUT]
%    obj : vb_batch_variable_table object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('column_name', 'var')
    error('column_name is a required parameter.');
end
if ~ischar(column_name) || isempty(column_name)
    error('invalid column name is given');
end

%
% --- Main Procedure
%

ix = strmatch(column_name, obj.column_name_list, 'exact');
if isempty(ix)
    warning(['Column name: ' column_name ' does not exist.']);
else
    % Remove column
    obj.column_name_list(ix(1)) = [];
    obj.table(:, ix(1)) = [];

    if isempty(obj.column_name_list)
        obj.column_name_list = cell(0);
    end
    if isempty(obj.table)
        obj.table = cell(1,0);
    end
    
end

%
% --- After check
%
if nargout < 1
    error('function caller should receive this object.');
end
