function [obj] = vb_batch_parm_set_add_parm(obj, parm, parm_type)
% Add parameter to the parameter set
% [USAGE]
%   [obj] = vb_batch_parm_set_add_parm(<obj>, <parm>, <parm_type>);
% [IN]
%          obj : vb_batch_parm_set object
%         parm : to be added parameter to the set
%    parm_type : parameter type such as 'brain_parm', 'head_parm',.. [STRING]
% [OUT]
%          obj : vb_batch_parm_set object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('parm', 'var')
    error('parm is a required parameter.');
end
if ~exist('parm_type', 'var')
    error('parm_type is a required parameter.');
end


%
% --- Main Procedure
%
Nparm = size(obj.list, 1);
obj.list{Nparm+1, 1} = parm;
obj.list{Nparm+1, 2} = parm_type;

%
% --- After check
%
if nargout < 1
    error('function caller should receive this object.');
end
