function file = vb_struct2file(p, file)
% Write structure information evaluated by command window.
%
% [USAGE]
%    file = vb_struct2file(p [,file]);
% [IN]
%       p : struct to be evaluated
%    file : filename[optional]
%           if this is empty, The file is created by tempname function.
% [OUT]
%    file : created filename
% [HISTORY]
%    2010-11-17 rhayashi
% [REFERENCE]
%    evalc
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~isstruct(p)
    error('input variable is not struct.');
end

%
% --- receive comand window output and write file
%
if ~exist('file', 'var')
    file = tempname;
end
fid = fopen(file, 'wt');
if fid == -1
    error('failed to open file(w)');
end
a = evalc('p');
fprintf(fid, '%s', a);
fclose(fid);

%
% --- Formatting
%
fid = fopen(file);
if fid == -1
    error('failed to open file(r).');
end

all = [];
while 1
    line = fgetl(fid);
    if line == -1, break; end
    % remove top line
    if strmatch('p =', line), continue; end
    % remove empty line
    if isempty(line), continue; end

    % forced to expand the character string
    field = sscanf(line, ' %s:');
    field = strrep(field, ':', '');

    para = p.(field);
    if ischar(para)
        ix = strfind(line, ':');
        line = [line(1:ix(1)) ' ' single_quoted_string(para)];
    end
    all = [all, sprintf('%s\n', line)];
end
fclose(fid);



%
% --- Write the formatted string into file
%
fid = fopen(file, 'wt');
if fid == -1
    error('failed to open file(w)');
end
fprintf(fid, '%s', all);
fclose(fid);



function out_str = single_quoted_string(in_str)

    out_str = sprintf('''%s''', in_str);
