function [obj] = vb_batch_mgr_set_output_index_list(obj, index_list)
% Set batch output index_list
% [USAGE]
%    [obj] = vb_batch_mgr_set_output_index_list(<obj><,index_list>)
% [IN]
%           obj : vb_batch_mgr object
%    index_list : list of ix_main  [Nx1]
%                      ix_main = 0: template parameter set
%                              > 0: created  parameter set
% [OUT]
%    obj : vb_batch_mgr object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('index_list', 'var')
    error('index_list is a required parameter.');
end

%
% --- Main Procedure
%
obj.ix_output = index_list;

%
% --- After check
%
if nargout < 1
    error('function caller should receive vb_batch_mgr object.');
end
