function [obj] = vb_batch_mgr_duplicate_parm(obj, ix_main, ix_sub)
% Duplicate specified parameter
% [USAGE]
%    [obj] = vb_batch_mgr_duplicate_parm(<obj>,<ix_main>,<ix_sub>);
% [IN]
%        obj : vb_batch_mgr object.
%    ix_main : parameter set specifier
%               = 0 : template parameter set
%               >=1 : batch parameter set
%     ix_sub : Nth parameter in the parameter set.
% [OUT]
%        obj : vb_batch_mgr object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('ix_main', 'var')
    error('ix_main is a required parameter.');
end
if ~exist('ix_sub', 'var')
    error('ix_sub is a required parameter.');
end

%
% --- Main Procedure
%

% Get specified parameter
[parm, parm_type] = vb_batch_mgr_get_parm(obj, ix_main, ix_sub);

% Add copy mark
if isfield(parm, 'time_stamp')
    parm.time_stamp = ['c' parm.time_stamp];
end

% Add parameter to the specified set
obj = vb_batch_mgr_add_parm(obj, ix_main, parm, parm_type);

%
% --- After check
%
if nargout < 1
    error('function caller should receive this object.');
end
