function [result, errmsg] = ...
                      vb_batch_mgr_build_batch_file(obj, proj_info, output_file)
% Output batch file
% [USAGE]
%    [result, errmsg] = 
%          vb_batch_mgr_build_batch_file(<obj>,<proj_info>,<output_file>);
% [IN]
%            obj : vb_batch_mgr object
%      proj_info : project information
%                  .proj_name : project name
%                  .proj_root : project root directory
%                  .proj_file : project file
%    output_file : batch output filename
% [OUT]
%       result : <<consntant>> SUCCESS (SUCCESS.m)
%                              FAILURE (FAILURE.m)
%       errmsg : reason for FAILURE.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('proj_info', 'var')
    error('proj_info is a required parameter.');
end
if ~exist('output_file', 'var')
    error('output_file is a required parameter.');
end

%
% --- Main Procedure
%

result = SUCCESS;
errmsg = 'Failed to save file.';

% get parameter set
ix_main_list = vb_batch_mgr_get_output_index_list(obj);
Nset = length(ix_main_list);
if Nset == 0
    result = FAILURE;
    errmsg = 'ID is not selected.';
    return;
end

%
% --- Make Variable which is put into a batch file.
%
parm_set = cell(Nset, 1);
for k=1:Nset
    ix_main = ix_main_list(k);
    parm_set{k,1} = vb_batch_mgr_get_parm_set(obj, ix_main);
end

s = struct;
s.header.proj_name  = proj_info.proj_name;
s.header.proj_root  = proj_info.proj_root;
s.header.proj_file  = proj_info.proj_file;
s.header.builder    = vb_batch_mgr_get_name(obj);
s.parm_set      = parm_set;

% save batch file
try
    vb_save_struct(output_file, s);
catch
    result = FAILURE;
    err = lasterror;
    errmsg = err.message;
end
