function [obj] = vb_batch_mgr_add_tool_mkdir(obj)
% Add make directory parameter to the template parameter.
% [USAGE]
%    [obj] = vb_batch_mgr_add_tool_mkdir(<obj>);
% [IN]
%    obj : vb_batch_mgr object
% [OUT]
%    obj : vb_batch_mgr object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end

%
% --- Main Procedure
%

mkdir_parm = struct;
mkdir_parm.directories = {'/home/subject/$ID$/brain'; '/home/subject/$ID$/fmri'};

% Get template parameter set
parm_set = vb_batch_mgr_get_parm_set(obj, 0);

% Add mkdir parm
parm_set = vb_batch_parm_set_add_parm(parm_set, mkdir_parm, 'mkdir_parm');

% Set updated template parameter set
obj = vb_batch_mgr_set_parm_set(obj, 0, parm_set);


%
% --- After check
%
if nargout < 1
    error('function caller should receive this object.');
end
