function vb_batch_list_add_item(fig, parm, parm_type)
% add item index to batch list gui.
% [USAGE]
%    vb_batch_list_add_item(<fig>, <parm>);
% [IN]
%          fig : figure handle of batch list gui.
%         parm : parmameter to be added.
%    parm_type : parameter string such as 'brain_parm', 'fmri_parm'
%
% [OUT]
%    none
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.');
end
if ~exist('parm', 'var')
    error('parm is a required parameter.');
end

%
% --- Main Procedure
%

% load data
data = guidata(fig);

% Add parameter to the vb_batch_manager
data.bmgr = vb_batch_mgr_add_parm(data.bmgr, 0, parm, parm_type);

% save data
guidata(fig, data);

% update listbox
Nparm = vb_batch_mgr_get_num_of_parm(data.bmgr, 0);
vb_batch_list_update_template_parm_listbox(fig);
