function vb_fmri_project_Tmap_cortex(brain_file,act_file,area_file,Tthres,Rthres,SPMimginfo,loadVmni)
% PROJECT VOXEL TMAP ON THE BRAIN SURFACE MODEL
%
% [Notice]
% spmT_*.img must be coregistered to T1-structural image used for creating
% a brain file
%
% [Syntax]
%  vb_fmri_project_Tmap_cortex(brain_file,act_file,area_file,Tthres,SPMimginfo)
%
% [Example]
% > brain_file = 'hoge.brain.mat';
% > act_file = 'hoge.act.mat';
% > area_file = 'hoge.area.mat';
% > Tthres    = 5; 
% > Rthres   = 3;
% > SPMimginfo = struct('dirname', '/home/hoge/hoge/spm/',...
% > imgfilenames,{'spmT_0001.img','spmT_0002.img'},imglabels,{'Right index',... 
% > 'Right hand gripping'});
% > vbdot_fmri_project_Tmap_cortex(brain_file,act_file,areafile,Tthres,Rthres,SPMimginfo)
%
% [Input]
%   brain_file : cortical surface model 
%   act_file   : act file 
%   area_file  : area file
%   Tthres     : T-value threshold 
%   Rthres     : radius threshold (mm)
%   SPMimginfo(ii) : arrays of struct containing information of T-image  
%       .dirname : directory name for image file 
%       .imgfilename :  file name of image to be projected  
%       .imglabel    :  label of image to be projected. These label
%                            are used as actkey and areakey.
% 
% [Optional]
%  loadVmni : if specfied as 1, loading coordinate of brain file as MNI coordinate  
%
% [Output]
%   Acts are added to "act_file" and Areas are added to "area_file"
%
% 2016/07/12 O.Yamashita
% * add loadVmni to input arguments to switch coordinate of brain file 
% 2016/07/06 O.Yamashita
% * solve the region expansion problem
% 2016/07/01 O.Yamashita
% * first version based on vbdot_fmri_project_Tmap_corext.m
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

fprintf('============== NOTICE ==========================\n')
fprintf('Please confirm spmT_*.img have been coregistered \n')
fprintf('to the T1-structural image used for creating \n');
fprintf('a brain file.  \n');
fprintf('================================================\n')

if nargin < 7
    loadVmni = 0;
end


spmdir = SPMimginfo(1).dirname;

fprintf('Image directory name : %s,...\n', spmdir);
for jj = 1 : length(SPMimginfo),
    fprintf('%s will be registered as %s ...\n', SPMimginfo(jj).imgfilename, SPMimginfo(jj).imglabel);
end


for jj = 1 : length(SPMimginfo),
    loadimgfile = [spmdir SPMimginfo(jj).imgfilename];
    key = SPMimginfo(jj).imglabel;

    % surface mesh
    if loadVmni
        V = vb_load_cortex(brain_file, 'MNI');
    else
        V = vb_load_cortex(brain_file, 'subj');
    end
    V = V * 1000;  % mm
      
    
    % vox image and coordinates
    VG=spm_vol(loadimgfile);
    [map,XYZ] = spm_read_vols(VG);

    %
    % thresholding affects resulting surface image !!!
    %
      
%     map(map < Tthres) = 0;
%    XYZ = XYZ(:,map~=0);  
%    map = map(map ~= 0)';
    
    ix = find(map~=0);  % brain mask
    XYZ = XYZ(:,ix);  
    map = map(ix);
    map(map < Tthres) = 0; % 

  
    r2thres = Rthres^2;  % half of diagonal line of cuboid
    
    
    % vox --> surf 
    Tval = vb_voximg2surimg(XYZ',map(:),V, r2thres, 1);

    
   % add act 
    fprintf('\nAdd T-map to %s with act-key %s \n', act_file, key)
    act.xxP = Tval;
    act.key = key;
    act.spmdir  = spmdir;
    act.imgname = SPMimginfo(jj).imgfilename;
    vb_add_act(act_file, act, [], OFF);

    % add area 
    fprintf('Add T-map to %s with area-key %s \n', area_file, key)
    area.Iextract = find(Tval~=0);
    area.key = key;
    area.spmdir  = spmdir;
    area.imgname = SPMimginfo(jj).imgfilename;
    vb_add_area(area_file, area, [], OFF);
    
    
end