function [G, ix, ix_ext, W, L] = vb_leadfield_preparation(lf_parm)
% Prepare leadfield 
%
% --- Syntax
% [G, ix, ix_ext, W, L] = vb_leadfield_preparation(lf_parm)
%
% --- Input
% lf_parm.brainfile
% lf_parm.areafile
% lf_parm.basisfile
% lf_parm.patch_norm
% lf_parm.reduce
% lf_parm.Rfilt
% lf_parm.area_key
% lf_parm.expand_spatial_filter
% lf_parm.remove_area_key
% lf_parm.spatial_smoother
%
% --- Output
% G     : leadfield matrix
% L     : current component number  %% Added by M. Sato 2008-7-4
% W     : spatial smoothing matrix
% ix    : vertex indices
% ix_ext: vertex indices of expandend area
%
% --- History
% 2008-06-26 Taku Yoshioka
% 2009-09-08 Taku Yoshioka (comment modified)
% 2017-03-16 rhayashi      added spatial_smoother 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% fields of 'lf_parm' used in this function
vb_struct2vars(lf_parm,{'basisfile','area_key','reduce','Rfilt',...
                    'brainfile','areafile','expand_spatial_filter',...
                    'patch_norm','remove_area_key','spatial_smoother'});

% Leadfield matrix
[G, L, W, ix, ix_ext] ...
    = vb_prepare_leadfield(basisfile, brainfile, areafile, area_key, ...
                        reduce, Rfilt, expand_spatial_filter, ...
                        patch_norm, remove_area_key, spatial_smoother);
