function	[jx, ix_in_ixsub]= vb_index2indexsub(ix, ixsub)
% Transform absolute index to relative index
% -- Syntax
% [jx] = vb_index2indexsub(ix, ixsub)
% [jx, ix_in_ixsub] = vb_index2indexsub(ix, ixsub)
% -- Input 
% ix    : target indices to be transformed
% ixsub : indices of sub-region
%
% -- Output
% Transform absolute index to index within 'ixsub'
% jx          : transformed indices w.r.t 'ixsub'
% ix_in_ixsub : absolute index included in both 'ixsub' & 'ix' 
%               vertex index in 'ix' which is included in 'ixsub'
% ix_in_ixsub = ixsub(jx)
%
% Example.
% ix=[1 5 10], ixsub=[5:10],
% --> jx = [1 6] 
%     ix_in_ixsub = [5 10]
%
% Modufied by M. Sato 2006/8/20
%   Input argument 'Nall' is removed.
%   Nall is automatically calculated.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

Nsub = length(ixsub);
Nall = max([ ix(:); ixsub(:) ]);

Itrans		  = zeros(Nall,1);
Itrans(ixsub) = 1:Nsub;

jx_tmp = Itrans(ix); 
jx = find(jx_tmp > 0);
jx = jx_tmp(jx);

ix_in_ixsub = ixsub(jx);
