function [nG_global, bsnorm, ix_global, ix_global_ex, W_global, L_global]...
    = vb_global_leadfield_preparation(bayes_parm, bsnorm, remove_area)
% Prepare leadfield of focal and global window
%
% -- Output
% nG_global   : normalized leadfield of global window
% bsnorm      : normalizing constant
%
% ix_global    : vertex indices of global window
% ix_global_ex : vertex indices of expandend global window
% W_global     : spatial smoothing matrix of global window
% L_global     : number of dipole orientation of global window
%
% 2005/08/16 O.Yamashita
% 2005/08/22 O.Yamshita ver.30b
% 2006/03/03 Taku Yoshioka, Support patch size normalization
% 2006/08/25 M. Sato sepalate leadfield_preparation to focal & global
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~isfield(bayes_parm, 'patch_norm')
    bayes_parm.patch_norm = ON;
end

% fields of 'bayes_parm' used in this function
vb_struct2vars(bayes_parm,{'basisfile_global','area_key_global', ...
   'reduce_global', 'Rfilt_global','brainfile','areafile', ...
   'expand_spatial_filter',  'area_key','patch_norm', 'basis_smoother'});

%% Leadfield matrix of global window
fprintf('--- Lead field matrix of global window \n');
if exist('remove_area','var') & remove_area == ON,
	% Remove focal area from global area
	[G_global, L_global, W_global, ix_global, ix_global_ex] = ...
	    vb_prepare_leadfield(basisfile_global, brainfile, areafile,...
	    area_key_global, reduce_global, Rfilt_global, expand_spatial_filter,...
	    patch_norm, area_key, basis_smoother);
else
	[G_global, L_global, W_global, ix_global, ix_global_ex] = ...
	    vb_prepare_leadfield(basisfile_global, brainfile, areafile,...
	    area_key_global, reduce_global, Rfilt_global, expand_spatial_filter,...
	    patch_norm, [], basis_smoother);
end

Nsession = length(G_global);  % Number of sessions

%% leadfield normalization 
if ~exist('bsnorm','var') | isempty(bsnorm)
	Bnorm = zeros(Nsession,1);
	
	for n = 1: Nsession
	    GG_global = sum(G_global{n}.^2, 2);
	    Bnorm(n)  = sum(GG_global)/length(GG_global); 
	end

	% Normalization constant of lead fields
	bsnorm = sqrt(mean(Bnorm)); 
end

for n=1:Nsession
  nG_global{n} = G_global{n}/bsnorm;
end;

