function	xxcv = vb_covariance_cal(xxP,nextIX,nextDD,Rradius,Rmax,Cov_fmri)
% Covariance calculation
%
% Ver 1.0 written by M. Sato  2003-3-15
% Modified by Taku Yoshioka 2003-08-13
%
% Cov_fmri: 0ʤfMRIưپȤʤ
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%%%%%%% Covariance calculation %%%%%%%
Nvertex		 = length(xxP);

val    = []; % Filter value
ipoint = []; % Center point index
inext  = []; % Neighbor index

for i=1:Nvertex,
	dd0    = nextDD{i};
	inx    = find( dd0 <= Rmax );		% Find neighbor index within Rmax
	
	ix	   = nextIX{i}(inx);			% neighbor index
	Nnext  = length(ix);
	ip	   = repmat( i ,[Nnext 1] );	% current  index
	dd	   = dd0(inx); 					% distance from point-i
	
	gauss  = exp( - (dd/Rradius).^2 );

	if Cov_fmri==0,
		Pval   = ones(Nnext,1);			% No fMRI-information
	else
		Pval   = xxP(i).*xxP(ix);		% fMRI-Activation at 'i' and 'ix'
	end;
	
	ipoint = [ ipoint ; ip ];
	inext  = [ inext  ; ix ];
	val    = [ val    ; Pval.*gauss ];
end;

xxcv = sparse( ipoint , inext , val , Nvertex, Nvertex, length(ipoint) ) ;
%xxcv = spdiags( xxP(Itrans(1:Nvertex)).^2 , 0, xxcv);

% Symmetrize matrix by shorter path
xxcv = max( xxcv , xxcv');

% Symmetrize matrix
%xxcv = (xxcv + xxcv')*0.5;

