
#include "matrix.h"
#include <math.h> /* Needed for the ceil() prototype */
#include "mex.h"


void mexFunction(
		 int nlhs,       mxArray *plhs[],
		 int nrhs, const mxArray *prhs[]
		 )
{
    /* Declare variable */
    mwSize   m,n,nzs;
    mwIndex  k,*irs,*jcs,*ir,*jc;
    double   *zp,*z,val;

	/*  Check for proper number of arguments. */
	if(nrhs!=2) 
	  mexErrMsgTxt("1 inputs required.");
	if(nlhs!=1) 
	  mexErrMsgTxt("One output required.");
	  
	/* S = sp_init_value(S, v) */
	
	/*  Get the number of elements. 
	nz  = (mwSize) mxGetNumberOfElements(prhs[0]);
*/
	if (!mxIsSparse(prhs[0])) {
	  mexErrMsgTxt("input must be sparse matrix");
	}
	/*  Get the number of dim. */
	m = (mwSize) mxGetM(prhs[0]);
	n = (mwSize) mxGetN(prhs[0]);
	nzs = (mwSize) mxGetNzmax(prhs[0]);
	
	/*  	*/
    ir = mxGetIr(prhs[0]);
    jc = mxGetJc(prhs[0]);
	zp = mxGetPr(prhs[0]);/* nonzero value */

	val = mxGetScalar(prhs[1]);

	
    /* Allocate space for sparse matrix */
    plhs[0] = mxCreateSparse(m,n,nzs,mxREAL);
	
    
	/*  Get a pointer to sparse matrix */
    irs = mxGetIr(plhs[0]);
    jcs = mxGetJc(plhs[0]);
	
	/*  Create a C pointer to a copy of the output matrix. */
	z = mxGetPr(plhs[0]);

    /* add elements */

    for (k=0; (k <= n ); k++) {
    	jcs[k] = (mwIndex) jc[k] ;
    }
    for (k=0; (k < nzs ); k++) {
	    irs[k] = (mwIndex) ir[k] ;
		z[k] = (double) val;
    }
}
