#include "mex.h"
#include "mexutil.h"

/*
 *  AJfilt = atimesj(Trst,Indx,Deltax,sum_ind,Jtmp(:,t_end:-1:(t_end-unidlt(end))));
 *
 * Get products of A and Jfilt with considering different time delay constants.  
 *
 * Written by M.Fukushima 2012/12/26
 * Original code is 'repmultiply.c'
 */

void mainfunc(double *Trst, double *Indx, double *Deltax, double *sum_ind, double *Jtmp, double *AJfilt, int Nvact, int Ntd, int Ncp)
{
  int i,j,count=0;
  double tmp=0;
  int indx,deltax; 
  double trst,jtmp;
  
  for (i=0; i<Nvact; i++) {
    for (j=0; j<*(sum_ind+i); j++) {
      trst   = *(Trst   + count*Nvact + i);
      indx   = *(Indx   + count*Nvact + i);
      deltax = *(Deltax + count*Nvact + i);
      jtmp   = *(Jtmp   + deltax*Nvact + indx-1);

      tmp += trst*jtmp;
      count++;
    }
   *(AJfilt+i) = tmp;
   tmp = 0;
   count = 0;
  }
}

/* The gateway routine */
void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[])
{
	double *Trst, *Indx, *Deltax, *sum_ind, *Jtmp, *AJfilt;
	int    RowTrst, ColTrst, RowIndx, ColIndx, RowDeltax, ColDeltax, Rowsum_ind, Colsum_ind, RowJtmp, ColJtmp;
	
	/*  Check for proper number of arguments. */
	if(nrhs!=5) 
	  mexErrMsgTxt("Five inputs required.");
	if(nlhs!=1) 
	  mexErrMsgTxt("One output required.");
	
	/*  Create a pointer to the inputs. */
	Trst    = mxGetPr(prhs[0]);
	Indx    = mxGetPr(prhs[1]);
	Deltax  = mxGetPr(prhs[2]);
	sum_ind = mxGetPr(prhs[3]);
	Jtmp    = mxGetPr(prhs[4]);
	
	/*  Get the dimensions of the matrix inputs. */
	RowTrst    = mxGetM(prhs[0]);
	ColTrst    = mxGetN(prhs[0]);
	RowIndx    = mxGetM(prhs[1]);
	ColIndx    = mxGetN(prhs[1]);
	RowDeltax  = mxGetM(prhs[2]);
	ColDeltax  = mxGetN(prhs[2]);
	Rowsum_ind = mxGetM(prhs[3]);
	Colsum_ind = mxGetN(prhs[3]);
	RowJtmp    = mxGetM(prhs[4]);
	ColJtmp    = mxGetN(prhs[4]);
	
	/*  Set the output pointer to the output matrix. 
		plhs[0] = mxCreateDoubleMatrix(my,ny, mxREAL);
		Create uninitialized matrix for speed up
	*/
	plhs[0] = mxCreateDoubleMatrixE(RowJtmp,1,mxREAL);
	
	/*  Create a C pointer to a copy of the output matrix. */
	AJfilt = mxGetPr(plhs[0]);
	
	mainfunc(Trst,Indx,Deltax,sum_ind,Jtmp,AJfilt,RowJtmp,ColJtmp,ColTrst);

}
