function	X = vb_read_vrml_coordinate(fname, Nskip, Nline, Mmax, key)
% Read Coordinate frpm XML-file
% 
% Coordinate3 {
%	point [ 
%		9.06 87.16 -851.32,
%		10.02 87.13 -851.20,
%			...
%	]
%	point [ 9.06 87.16 -851.32,
%		10.02 87.13 -851.20,
%			...
%       76.95 -72.55 23.16 ]
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


fid=fopen(fname);

% Skip lines until data
for n=1:Nskip
    next_line = fgetl(fid);
end

% Read data
X  = zeros(Nline,Mmax);
nn = 0;

% Check case such as [ 12, 13, 
ix  = strfind(next_line,key);

if ~isempty(ix)
	next_line = next_line(ix+1:end);
	
	if ~isempty(next_line)
		x  = sscanf(next_line,'%f');
		Nx = length(x);
		if Nx > 0,
			nn = nn + 1;
			X(nn, 1:Nx) = x';
		end
	end
end

for n=1:Nline
    next_line = fgetl(fid);

	x  = sscanf(next_line,'%f');
	Nx = length(x);
	if Nx > 0,
		nn = nn + 1;
		X(nn, 1:Nx) = x';
	end
end

fclose(fid);

X = X(1:nn,:);
