function [V,F,C,X,Y,Z] = vb_get_vivid_proj(Coord, LR)
% Project SPM-R coordinate to 2D screen
%  [V,F,C,X,Y,Z] = vb_get_vivid_proj(Coord, LR)
% --- Input
% Coord : Left / Right /Front  head coordinate
%  'MGF'- File
%        .LV   / .RV   / .FV   : 3D-Coordinate   : [Npoint 3]  [m]
%        .LF   / .RF   / .FF   : Patch index     : [Npatch 4]
%        .Limg / .Rimg / .Fimg : 3D RGB image    : [Npoint 3]
% LR    = 'L' or 'R' or 'F' : Left/Right/Front
% --- Output
% V : 3D coordinate corresponding to view point 'Left/Right/Front'
% X : X-coordinate in projected 2D screen-space
% Y : Y-coordinate in projected 2D screen-space
% Z : Z-coordinate = 0 
% F : patch index
% C : Color of vertex
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% SPM-R
%   X: ->   Left(-191/2)   -> Right(191/2)
%   Y: ->   Back(-256/2)   -> Front(256/2)
%   Z: ->   Bottom(-256/2) -> Top(256/2)
%
%view([-90, 0]);    % Left view  (from -X axis)
%view([ 90, 0]);    % Right view (from +X axis)
%view([180, 0]);    % Front view (from +Y axis)
%view([  0, 90]);   % Top view   (from +Z axis)

angleL = [-90, 0];
angleR = [ 90, 0];
angleF = [180, 0];

switch	LR
case	'L'
	V = Coord.LV;
	F = Coord.LF;
	C = Coord.Limg;
	T = viewmtx(angleL(1),angleL(2));
case	'R'
	V = Coord.RV;
	F = Coord.RF;
	C = Coord.Rimg;
	T = viewmtx(angleR(1),angleR(2));
case	'F'
	V = Coord.FV;
	F = Coord.FF;
	C = Coord.Fimg;
	T = viewmtx(angleF(1),angleF(2));
end

NV = size(V,1);
X  = [V ones(NV,1)]*T(1,:)';
Y  = [V ones(NV,1)]*T(2,:)';
Z  = zeros(NV,1);

return
%%%%%%%%%%%%%%%%%%% END %%%%%%%%%%%%%%%%%%%%

h = figure;

subplot(1,2,1)
% Plot face on projected 2D screen
patch('Faces',F,'Vertices',[X Y Z],'FaceColor','interp',...
	'FaceVertexCData',C,'EdgeColor','none',...
	'FaceLighting','none');
hold on
view([ 0, 90]);
axis equal

subplot(1,2,2)
% Plot 3D face
patch('Faces',F,'Vertices',V,'FaceColor','interp',...
	'FaceVertexCData',C,'EdgeColor','none',...
	'FaceLighting','none');
hold on
view(T);
axis equal

return
