function    Vp = vb_get_ref_point(Coord, LR, mtype)
% Get marker 3D coordinate from the VIVID 2D-image by mouse click
%   Vp = vb_get_ref_point(Coord, 'L')   for Left  Face
%   Vp = vb_get_ref_point(Coord, 'R')   for Right Face
%
% Coord : Vivid coordinate
% LR    : Left/Right
% mtype ; Marker type and size (structure)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('mtype','var')
    msize1 = 15;
    mtype1 = '.y';
    msize2 = 20;
    mtype2 = '.r';
else
    msize1 = mtype.msize1;
    mtype1 = mtype.mtype1;
    msize2 = mtype.msize2;
    mtype2 = mtype.mtype2;
end

if isfield(Coord, 'FV')
	NX  = 3;
	NY  = 2;
	Flg = 1;
else
	NX  = 2;
	NY  = 2;
	Flg = 0;
end

switch	LR
case	'L'
	Nfig = 1;
	V = Coord.LV;
	X = Coord.LX;
	Y = Coord.LY;
case	'F'
	if Flg == 1,
		Nfig = 2;
		V = Coord.FV;
		X = Coord.FX;
		Y = Coord.FY;
	else
		Nfig = 1;
		V = Coord.LV;
		X = Coord.LX;
		Y = Coord.LY;
	end
case	'R'
	if Flg == 1,
		Nfig = 3;
	else
		Nfig = 2;
	end
	V = Coord.RV;
	X = Coord.RX;
	Y = Coord.RY;
end

figure(gcf);
%
% Left/Right face
%
subplot(NY,NX,Nfig)

% Input marker position  by mouse click
[xp,yp] = ginput(1);

% Find nearest 3D & 2D-coordinate to the target point
[Vp, Xp, Yp, dmin] = vb_get_3d_point([xp,yp],V,X,Y);

% Plot marker on 2D-image
plot(Xp,Yp,mtype1,'MarkerSize',msize1);

% Plot marker on 3D face
subplot(NY,NX,Nfig+NX)
plot3(Vp(:,1),Vp(:,2),Vp(:,3),mtype2,'MarkerSize',msize2);
