function	[dmean1, dmean2] = vb_get_fit_error(digitizerfile)
% get mean distance error of fitting
% 
% dmean1 = Mean distance for scanned face
% dmean2 = Mean distance for head points
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

load(digitizerfile,'fit_data');

Nscan = size(fit_data.Vscan,1);
Npos  = size(fit_data.Vpos,1);

dmean1 = sum(fit_data.dmin(1:Nscan))/Nscan;
dmean2 = sum(fit_data.dmin(Nscan+1:end))/Npos;
