function [coordtype] = vb_msrmnt_load_coordtype(msrmnt)
% read coordinate type from MEG-MAT or EEG-MAT file
% [usage]
%   [coordtype] = vb_msrmnt_load_coordtype(msrmnt)
% [input]
%      msrmnt : <required> <<file>> measurement file - MEG-MAT or EEG-MAT
% [output]
%   coordtype : <<string>> coordinate type e.g. 'SPM_Right_M'
%             :  If measurement file does not have any appropriate field, 
%             :  return empty.
%             :  If measurement file is invalid,
%             :  return 'BAD_MEG(EEG)_FILE' for now
% [note]
%
% [history]
%   2008-04-01 (Sako) initial version
%   2011-06-01 (Sako) converted return values of vb_load_device to upper case
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('msrmnt', 'var'), msrmnt = ''; end
[msrmnt] = inner_check_arguments(msrmnt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
[measurement] = vb_load_device(msrmnt);
Measurement = upper(measurement);

switch Measurement
  case 'MEG'
    coordtype = vb_megfile_load_coordtype(msrmnt);
  case 'EEG'
    coordtype = vb_eegfile_load_coordtype(msrmnt);
  case 'INFO'
    load(msrmnt, 'fileinfo');
    coordtype = vb_msrmnt_load_coordtype(fileinfo.filename{1});
  otherwise
    coordtype = '';
    fprintf('(%s)unexpected Measumrement : %s\n', ...
      mfilename, Measurement);
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [msrmnt] = inner_check_arguments(msrmnt)
func_ = mfilename;
if isempty(msrmnt)
  fprintf('(%s)msrmnt is invalid\n', func_);
  return;
end

if exist(msrmnt, 'file') ~= 2
  fprintf('(%s)cannot find msrmnt : %s\n', func_, msrmnt);
  msrmnt = '';
  return;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
