function [result] = vb_msrmnt_active_channel_is_valid(msrmnt_file)
% check whether active channel field is valid or not from measurement file
% [usage]
%   [result] = vb_msrmnt_active_channel_is_valid(msrmnt_file)
% [input]
%   msrmnt_file : <required> <<file>> MEG-MAT file or EEG-MAT file
% [output]
%        result : <<boolean>>
%               :   true) valid
%               :  false) invalid
% [note]
%   @see vb_load_measurement_info.m
%   @see vb_info_active_channel_is_valid.m
% [history]
%   2008-06-04 (Sako) initial version
%   2009-09-01 (Sako) substituted vb_load_measurement_info for vb_load_meg_info
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('msrmnt_file', 'var'), msrmnt_file = ''; end
[msrmnt_file] = inner_check_arguments(msrmnt_file);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
info = vb_load_measurement_info(msrmnt_file);
result = vb_info_active_channel_is_valid(info);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [msrmnt_file] = inner_check_arguments(msrmnt_file)
func_ = mfilename;
if isempty(msrmnt_file)
  error('(%s)msrmnt_file is a required parameter', func_);
end

if exist(msrmnt_file, 'file') ~= 2
  error('(%s)cannot find msrmnt_file : %s', func_, msrmnt_file);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
