function [pretrigger] = vb_loadspec_get_pretrigger(loadspec)
% <<getter>> pretrigger in LoadSpec
% [usage]
%   [pretrigger] = vb_loadspec_get_pretrigger(loadspec)
% [input]
%     loadspec : <required> <<struct>> LoadSpec
% [output]
%   pretrigger : pre-trigger value of LoadSpec
% [note]
%   if there is not a pretrigger field in loadspec, return 0
% [history]
%   2008-02-21 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('loadspec', 'var'), loadspec = []; end
[loadspec] = inner_check_arguments(loadspec);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
pretrigger = loadspec.Pretrigger;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [loadspec] = inner_check_arguments(loadspec)
func_ = mfilename;
if isempty(loadspec)
  error('(%s)loadspec is a required parameter', func_);
end

if ~isfield(loadspec, 'Pretrigger')
  loadspec.Pretrigger = 0;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
