function [ch_name] = vb_loadspec_get_channel_name(loadspec)
% <<getter>> channel name in LoadSpec
% [usage]
%   [ch_name] = vb_loadspec_get_channel_name(loadspec)
% [input]
%   loadspec : <required> <<struct>> LoadSpec
% [output]
%    ch_name : channel name value of LoadSpec
% [note]
%   if there is not a channel name field in loadspec, return ''
% [history]
%   2008-02-21 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('loadspec', 'var'), loadspec = []; end
[loadspec] = inner_check_arguments(loadspec);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
ch_name = loadspec.ChannelName;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [loadspec] = inner_check_arguments(loadspec)
func_ = mfilename;
if isempty(loadspec)
  error('(%s)loadspec is a required parameter', func_);
end

if ~isfield(loadspec, 'ChannelName')
  loadspec.ChannelName = 0;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
