function ch_info = vb_info_get_channel_info(info, ch_type)
% return ChannelInfo struct in info (MEGinfo or EEGinfo)
% [usage]
%   [ch_info] = vb_info_get_channel_info(info, ch_type)
% [input]
%      info : <required> <<struct>> MEGinfo or EEGinfo
%   ch_type : <optional> [0] | 1 | 2
%           :  0) info.ChannelInfo
%           :  1) info.ExtraChannelInfo
%           :  2) all channels
% [output]
%   ch_info : <<struct>> fields are as follows:
%           :   .Active [Nchannel x 1] <<boolean>>
%           :   .Name   {Nchannel x 1}
%           :   .ID     [Nchannel x 1]
%           :   .Type   [Nchannel x 1]
% [note]
%   return format is like info.ChannelInfo not be like ExtraChannelInfo
% [history]
%   2009-07-27 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end
if ~exist('ch_type', 'var'), ch_type = []; end
[info, ch_type] = inner_check_arguments(info, ch_type);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
% --- initialize
ch_info = [];

if ch_type == 0
  if isfield(info, 'ChannelInfo') && ~isempty(info.ChannelInfo)
    ch_info = info.ChannelInfo;
  end
elseif ch_type == 1
  if isfield(info, 'ExtraChannelInfo') && ~isempty(info.ExtraChannelInfo)
    ex_info = info.ExtraChannelInfo;
    ch_info.Active = ex_info.Channel_active;
    ch_info.Name   = ex_info.Channel_name;
    ch_info.Type   = ex_info.Channel_type;
    ch_info.ID     = ex_info.Channel_id;
  end
elseif ch_type == 2
  if isfield(info, 'ChannelInfo') && ~isempty(info.ChannelInfo)
    ch_info = info.ChannelInfo;
  else
    ch_info.Active = [];
    ch_info.Name   = {};
    ch_info.ID     = [];
    ch_info.Type   = [];
  end
  if isfield(info, 'ExtraChannelInfo') && ~isempty(info.ExtraChannelInfo)
    ex_info = info.ExtraChannelInfo;
    ch_info.Active = [ch_info.Active; ex_info.Channel_active];
    ch_info.Name   = [ch_info.Name;   ex_info.Channel_name];
    ch_info.Type   = [ch_info.Type;   ex_info.Channel_type];
    ch_info.ID     = [ch_info.ID;     ex_info.Channel_id];
  end
else
  warning('(%s) unknown ch_type : %d\n', mfilename, ch_type);
end

return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info, ch_type] = inner_check_arguments(info, ch_type)
func_ = mfilename;
if isempty(info)
  error('(%s) info is a required parameter', func_);
end

if isempty(ch_type)
  ch_type = 0;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
