function [active_trial] = vb_info_get_active_trial(info)
% <<getter>> return active trial field from MEGinfo or EEGinfo
% [usage]
%   [active_trial] = vb_info_get_active_trial(info)
% [input]
%           info : <required> <<struct>> MEGinfo or EEGinfo
% [output]
%   active_trial : active trial field as it is
% [note]
% 
% [history]
%   2008-04-14 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end
[info] = inner_check_arguments(info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if ~isfield(info, 'ActiveTrial')
  active_trial = [];
  return;
end
active_trial = info.ActiveTrial;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info] = inner_check_arguments(info)
func_ = mfilename;
if isempty(info)
  error('(%s)info is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
