function new_info = vb_info_add_preprocess_parm(info, parm)
% add preprocess_parm to MEGinfo or EEGinfo
% [usage]
%   new_info = vb_info_add_preprocess_parm(info, parm)
% [input]
%       info : <required> <<struct>> MEGinfo or EEGinfo
%       parm : <required> <<struct>> added preprocess_parm
% [output]
%   new_info : updated MEGinfo or EEGinfo
% [note]
%   
% [history]
%   2008-04-11 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENT --- %
if ~exist('info', 'var'), info = []; end
if ~exist('parm', 'var'), parm = []; end
[info, parm] = inner_check_argument(info, parm);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if ~isfield(info, 'History')
  len_history = 0;
else
  len_history = length(info.History);
end

new_info = info;
new_info.History{len_history + 1} = parm;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_argument()
%
function [info, parm] = inner_check_argument(info, parm)
func_ = mfilename;
if isempty(info)
  error('(%s)info is required', func_);
end

if isempty(parm)
  error('(%s)parm is required', func_);
end
return;
%
% --- end of inner_check_argument()

%%% END OF FILE %%%
