function [result] = vb_info_active_trial_is_valid(info)
% check whether active trial field is valid or not
% [usage]
%   [result] = vb_info_active_trial_is_valid(info)
% [input]
%     info : <required> <<struct>> MEGinfo or EEGinfo
% [output]
%   result : <<boolean>>
%          :   true) valid
%          :  false) invalid
% [note]
%   for now, MEGinfo and EEGinfo has the same field name for active trial
%   invalid conditions are as follows.
%    * There is not the appropriate field
%    * Active trial field is empty
%    * The length of active trial is different from the number of trial
% [history]
%   2008-04-11 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end
[info] = inner_check_arguments(info);


% --- MAIN PROCEDURE --------------------------------------------------------- %
%
result = false;
if ~isfield(info, 'ActiveTrial') || isempty(info.ActiveTrial)
  return;
end

Ntrial = inner_get_trial_number(info);
len_active = length(info.ActiveTrial);
if Ntrial ~= len_active
  fprintf('(%s)numbers are different trial(%d) and ActiveTrial(%d)\n', ...
    mfilename, Ntrial, len_active);
  return;
end

result = true;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info] = inner_check_arguments(info)
func_ = mfilename;
if isempty(info)
  error('(%s)info is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()

% --- inner_get_trial_number()
%
function Ntrial = inner_get_trial_number(info)
if isfield(info, 'Trial')
  Ntrial = length(info.Trial);
else
  Ntrial = 0;
end
return;
%
% --- end of inner_get_trial_number()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
