function [dir_name, real_dir] = vb_device_make_data_dir(base_file, mk_swt)
% generate default directory name for data and make it if necessary
% [usage]
%   [dir_name, real_dir] = vb_device_make_data_dir(base_file, mk_swt)
% [input]
%   base_file : <required> base file name
%             :  default directory name is derived from this file name
%             :  of base_file
%      mk_swt : <optional> switch to make directory [1] or 0
%             :  1) make
%             :  0) do not make
% [output]
%    dir_name : generated directory name
%    real_dir : real directory path to be able to make
% [note]
%
% [history]
%   2011-02-18 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('base_file', 'var'), base_file = ''; end
if ~exist('mk_swt', 'var'), mk_swt = []; end
[base_file, mk_swt] = inner_check_arguments(base_file, mk_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%

% --- generate directory name
[fpath, fname] = vb_get_file_parts(base_file);
idx = strfind(fname, '.')-1;
dir_name_base = [fname(1:idx)];
dir_name = ['./' dir_name_base];

% --- make directory if necessary
if isempty(fpath)
  fpath = '.';
end
real_dir = fullfile(fpath, dir_name_base);
if mk_swt == 1 && exist(real_dir, 'dir') ~= 7
  vb_mkdir(real_dir);
end

return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [base_file, mk_swt] = inner_check_arguments(base_file, mk_swt)
func_ = mfilename;
if isempty(base_file)
  error('(%s) base_file is a required parameter', func_);
end

if isempty(mk_swt)
  % --- make directory if it does not exist
  mk_swt = 1;
  
  % --- do not make directory even if it does not exist
  % mk_swt = 0;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
