%
% define constants for device
% [history]
%   2006-12-04 (Sako) initial version
%   2007-08-23 (Sako) added status channel of EEG
%   2011-02-07 (Sako) changed definitions of FILE_EXT_BIN
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)
FILE_EXT_BIN_CH_EEG = 'ch.eeg.dat';
FILE_EXT_BIN_CH_MEG = 'ch.meg.dat';
FILE_EXT_BIN_TR_EEG = 'tr.eeg.dat';
FILE_EXT_BIN_TR_MEG = 'tr.meg.dat';

STANDARD_BIN_DATA_TYPE = 'float32';
STANDARD_BIN_DATA_SIZE = 4;

STATUS_CH_DATA_TYPE = 'bit24';
STATUS_BIN_DATA_SIZE = 3;
STATUS_CH_LABEL = 'Status';

% --- ACQ TYPE
MEG_ACQTYPE_CON_RAW = 'Continuous_Raw';
MEG_ACQTYPE_EVO_AVE = 'Evoked_Ave';
MEG_ACQTYPE_EVO_RAW = 'Evoked_Raw';

AcqTypeContinuousRaw = 1;
AcqTypeEvokedAve     = 2;
AcqTypeEvokedRaw     = 3;

DEFAULT_CH_FILE_BODY     = 'test';
DEFAULT_CH_FILE_BODY_EEG = 'eeg';
DEFAULT_CH_FILE_BODY_MEG = 'meg';
DEFAULT_CH_FILE_BODY_UNKNOWN = 'measurement';

DEFAULT_BIT_LEN = 24;
DEFAULT_TRIGGER_CH_NUM = 16;

EEGINFO_DEFAULT_AUX_LABEL  = 'AUX';

EEGINFO_PROCESS_REFERENCE = 'REFERENCE';
EEGINFO_PROCESS_FILTER    = 'FILTER';
EEGINFO_PROCESS_SEGMENT   = 'SEGMENT';

EEGINFO_REFERENCE_COMMON = 'COMMON'; % common reference
EEGINFO_REFERENCE_AV     = 'AV';   % average potential reference
EEGINFO_REFERENCE_BNE    = 'BNE';  % balanced noncephalic referential electrode
EEGINFO_REFERENCE_BD     = 'BD';   % bipolar derivation
EEGINFO_REFERENCE_SDM    = 'SDM';  % SD (source derivation) method

EEGINFO_FILTER_LPF  = 'LPF';       % low-pass filter
EEGINFO_FILTER_HPF  = 'HPF';       % high-pass filter
EEGINFO_FILTER_BPF  = 'BPF';       % band-pass filter

% EEGINFO_FILTER_TYPE_

EEG_TRIGGER_CHANNEL = 'Triggers and Status';
TRIGGER_HOW_FULL = 'FULL';
TRIGGER_HOW_SEMI = 'SEMI';
TRIGGER_HOW_FILE = 'FILE';
TRIGGER_HOW_MANUAL = 'MANUAL';
%%% END OF FILE %%%
