function	vb_plot_status(fname, plot_parm)
% plot status signal and extracted trials
%   vb_plot_status(fname)
% fname : trigger info file name
%
% status : status signal
% status_val(m) = status value for m-th condition (m=1:Ncomdition)
% trig(n)       : Onset time index for n-th trial 
% cond_id(n)    : Condition ID for n-th trial 
% ix_trial(:,n) : Time index for n-th trial   [Ntrial x Tperiod]
%                 Tperiod : # of time sample in one trial
%                 Ntrial  : # of trials
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

npng  = 0;
NXmax = 4;
NYmax = 4;
Ymax = [];
Ymin = [];
plot_status = 1;
plot_abs = 1;
Pretrigger_ms   = [ ];  % [msec]
Posttrigger_ms  = [ ]; % [msec]

if nargin == 1, plot_parm = []; end
% Output PNG file
if ~isfield(plot_parm,'mode'), plot_parm.mode = 1; end
if ~isfield(plot_parm,'png'), plot_parm.png = []; end
% Max number of trials in X
if isfield(plot_parm,'NXmax'), NXmax = plot_parm.NXmax; end
% Max number of subplot in Y
if isfield(plot_parm,'NYmax'), NYmax = plot_parm.NYmax; end

if isfield(plot_parm,'Ymax'), Ymax = plot_parm.Ymax; end
if isfield(plot_parm,'Ymin'), Ymin = plot_parm.Ymin; end
if isfield(plot_parm,'status'), plot_status = plot_parm.status; end
if isfield(plot_parm,'abs'), plot_abs = plot_parm.abs; end
if isfield(plot_parm,'Pretrigger_ms'),  Pretrigger_ms  = plot_parm.Pretrigger_ms ; end
if isfield(plot_parm,'Posttrigger_ms'), Posttrigger_ms = plot_parm.Posttrigger_ms; end

info = load(fname);
parm = info.parm;
ix_trial   = info.ix_trial;
trig       = info.trig;
status     = info.status;
status_out = info.status_out;
status_val = info.status_val;
cond_id    = info.cond_id;

% Sampling frequency
fs = parm.fsamp;
dt = 1000/fs; % [msec]
dT = 0; % [msec]

[Nch, T] = size(status);
Ncond = length(status_val);

% Sampleing time [msec]
t = (0:(T-1))*dt;

% onset time and trial period
Ntrial  = length(trig);

if isfield(plot_parm,'Ntrial') && ~isempty(plot_parm.Ntrial)
	Ntrial_id = plot_parm.Ntrial; 
else
	Ntrial_id = 1:Ntrial;
end

if ~isempty(Pretrigger_ms)
	% Sample number for Pre/Post period
	Pretrigger  = ceil(Pretrigger_ms *(fs/1000));
	Posttrigger = ceil(Posttrigger_ms*(fs/1000));
	% Time index for one trial
	ix = (-Pretrigger:Posttrigger)';
	Tp = length(ix);
	
	% Time index for all trials extracted from 'trig'
	ix_trial = repmat(ix,[1 Ntrial]) + repmat(trig,[Tp 1]);
end

trg_on  = trig*dt;
trg_on  = [trg_on ;trg_on];

trg_st  = ix_trial(1,:)*dt;
trg_end = ix_trial(end,:)*dt;
trg_mid = mean(trg_end - trg_st);
trg_st2  = trg_st  - trg_mid/2;
%trg_end2 = trg_end + trg_mid/2;

Nfig = ceil(Ntrial/NXmax);

switch	plot_parm.mode
case	1
	NX   = 1;
	NXmax = ceil(Ntrial/NYmax);
	Nfig  = NYmax;
case	2
	NX   = NXmax;
case	3
	NX   = 1;
end

if Nfig < NYmax
	NY = Nfig;
else
	NY = NYmax;
end

switch	plot_parm.mode
case	1
	% --- plot all trial
	plot_multi_cond;
case	2
	% --- plot one trial in one subplot
	plot_each_trial;
case	3
	% --- plot multi trial in one subplot
	plot_multi_trial;
end

end_figure(npng);

% Program-END of primary function
%return

% --- plot one trial in one subplot
function	plot_each_trial
	nfig = 1;
	npng = 0;
	figure;
	
	% plot extracted epoch
	for n=Ntrial_id
		id = cond_id(n);
		if Nch == Ncond
			y  = status(id,:);
			ys = status_out(id,:);
		else
			y  = status;
			ys = status_out;
		end
		
		if plot_abs == 1, y = abs(y); end
		
		y  = y/max(ys);
		ys = ys/max(ys);
		
		ymax = max(y(ix_trial(:,n)));
		
		y_trg    = [0; ymax];
		y_status = [status_val(id); status_val(id)];
		
		%nfig = new_figure(NX,NY,nfig,fname,plot_parm);
		[nfig ,npng] = new_figure(nfig,npng);
		
		subplot(NY,NX,nfig); 
		
		plot(t,y)
		hold on
		plot(t,ys,'-b')
		plot(trg_on(:,n), y_trg ,'-r')
		
		if plot_status == 1
%			plot([trg_st(n) ;trg_end(n)], y_status ,'-r','LineWidth',5)
			plot([trg_st(n) ;trg_end(n)], y_status ,'-r')
		end
		
		xlim([trg_st(n)-dT , trg_end(n)+dT])
		if ~isempty(Ymax)
			ylim([Ymin Ymax])
		end
%		if strcmp( parm.trig_type ,'voice' ), ylim([0 ymax]); end;
		
		nfig=nfig+1;
	end
	
end
% END plot_each_trial

% --- plot multi_trial in one subplot
function	plot_multi_trial
	nfig = 1;
	npng = 0;
	figure;
	
	% plot extracted epoch
	for m=1:Nfig
		
		[nfig ,npng] = new_figure(nfig,npng);
		subplot(NY,NX,nfig); 
		
		for n=1:Ncond
			id = cond_id(n);
			if Nch == Ncond
				y  = status(id,:);
				ys = status_out(id,:);
			else
				y  = status;
				ys = status_out;
			end
			
			if plot_abs == 1, y = abs(y); end
			
			y  = y/max(ys);
			ys = ys/max(ys);
			
			ymax = max(y(ix_trial(:,n)));
			ix = find(cond_id == n);
			NN = length(ix);
			
			y_trg    = [zeros(1, NN); repmat(ymax,1,NN)];
			y_status = repmat(status_val(n), 2, NN);
			
			plot(t,y)
			hold on
			plot(t,ys,'-b')
			plot(trg_on(:,ix), y_trg ,'-r')
			if plot_status == 1
%				plot([trg_st(ix) ;trg_end(ix)], y_status ,'-r','LineWidth',5)
				plot([trg_st(ix) ;trg_end(ix)], y_status ,'-r')
			end
		end
		
		n1 = NXmax*(m-1) + 1;
		n2 = min(n1+NXmax, Ntrial);
		xlim([trg_st2(n1) trg_st2(n2)])
		
		if m == Nfig
			xlim([trg_st2(n1) t(end)])
		end
		if ~isempty(Ymax)
			ylim([Ymin Ymax])
		end
%		if strcmp( parm.trig_type ,'voice' ), ylim([0 ymax]); end;
		nfig=nfig+1;
	end
end
%return
% END plot_multi_trial

% --- plot multi_trial in one subplot
function	plot_multi_cond
	nfig = 1;
	npng = 0;
	figure;
	
	% plot extracted epoch
	if Nch == Ncond
		Mcond = 1;
	else
		Mcond = Ncond;
	end
	
	for ch=1:Nch
		y  = status(ch,:);
		ys = status_out(ch,:);
		
		if plot_abs == 1, y = abs(y); end
		
		y  = y/max(ys);
		ys = ys/max(ys);
		
		for m=1:Nfig
			[nfig ,npng] = new_figure(nfig,npng);
			subplot(NY,NX,nfig); 
		
			for n=1:Mcond
				if Nch == Ncond
					n_cond = ch;
				else
					n_cond = n;
				end

				ymax = max(y(ix_trial(:,n)));
				ix = find(cond_id == n_cond);
				NN = length(ix);
				
				y_trg    = [zeros(1, NN); repmat(ymax,1,NN)];
				y_status = repmat(status_val(n), 2, NN);
				
				plot(t,y)
				hold on
				plot(t,ys,'-b')
				plot(trg_on(:,ix), y_trg ,'-r')
				
				if plot_status == 1
%					plot([trg_st(ix) ;trg_end(ix)], y_status ,...
%						 '-r','LineWidth',5)
					plot([trg_st(ix) ;trg_end(ix)], y_status ,'-r')
				end
			end
		
			n1 = NXmax*(m-1) + 1;
			n2 = min(n1+NXmax, Ntrial);
			xlim([trg_st2(n1) trg_st2(n2)])
			if m == Nfig
				xlim([trg_st2(n1) t(end)])
			end
			if ~isempty(Ymax)
				ylim([Ymin Ymax])
			end
			
%			if strcmp( parm.trig_type ,'voice' ), ylim([0 ymax]); end;
			nfig=nfig+1;
		end
	end
end
%return
% END plot_multi_trial

%function	nfig = new_figure(NX,NY,nfig,fname,plot_parm)
function	[nfig ,npng] = new_figure(nfig,npng)
	if nfig > NX*NY
		nfig0 = ceil(NX/2);
		subplot(NY,NX,nfig0);
		title(['Status signal: ' fname],'Interpreter','none')
		
		if ~isempty(plot_parm.png)
			npng = npng + 1;
			nstr = num2str(npng);
			print(gcf, '-dpng', [plot_parm.png '_' nstr '.png']);
			close
		end
		figure; nfig=1; 
    end
end
% END new_figure

function	end_figure(npng)
	if ~isempty(plot_parm.png)
		nfig0 = ceil(NX/2);
		subplot(NY,NX,nfig0);
		title(['Status signal: ' fname],'Interpreter','none')
		npng = npng + 1;
		nstr = num2str(npng);
		print(gcf, '-dpng', [plot_parm.png '_' nstr '.png']);
		close
	end

end
% END end_figure

end
% Nested function END for primary function
