function	[ix , status_val, status_out] = ...
			vb_get_trigger_multi(status,status_level,parm)
% Find event onset time points for 'multi' channel bit pattern
%   
%	[ix,status_val,status_out] = ...
%		vb_get_trigger_multi(status,status_level,parm);
% --- Input
% status : multi channel event signal      [Nch x T]
% status_level : multi channel bit pattern [Nch x 1]
% parm.trig_type = 'multi'
% parm.slope = 'const_start' or 'const_end'
% parm.t_stay : minimum length to stay 'status_level' [default = 10]
%               'status' should be stay at the value 'status_level' 
%               for more than 't_stay'
% --- Output
% ix : time index corresponding to the event onset
% status_val = status_level
% status_out = Binarized status signal
% 
% 2012-1-8  Masa-aki Sato 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if isfield(parm,'t_stay')
	t_stay = parm.t_stay;
else
	t_stay = 10;
end

ix = [];
status_val = status_level;
status_out = status;

switch	lower(parm.trig_type)
case	'multi'
	% Binarization
	smax = max(status,[],2);
	jj = find( smax > 0 );
	status(jj,:) = vb_repmultiply(status(jj,:), 1./smax(jj));
	status(jj,:) = ( status(jj,:) > 0.5 );
	
	switch	lower(parm.slope)
	case	'const_start'
		ix = vb_multi_bit_start(status,status_level,t_stay);
	case	'const_end'
		ix = vb_multi_bit_end(status,status_level,t_stay);
	end
	
	status_out = status;
end
