function	[ix , status_val, status_out] = ...
			vb_get_trigger_event(status,status_level,parm)
% Find time points for event onset
%   [ix , status_val] = vb_get_trigger_event(status, status_level, parm)
% --- Input
% status : status signal
% status_level : status level for onset
% parm.trig_type = 'integer' or 'analog' or 'voice' or 'emg'
% parm.slope = 'const_start' or 'const_end'    if trig_type = 'integer'
%              'low_to_high' or 'high_to_low'  if trig_type = 'analog'
%               No meaning                     if trig_type = 'voice','emg'
% parm.t_stay : minimum length to stay 'status_level' [default = 10]
%               'status' should be stay at the value 'status_level' 
%               for more than 't_stay'
% --- Output
% ix : time index corresponding to the event onset
% status_val = status value used for thresholding
% status_out = (smoothed) status signal used for onset search
% --- Optional parm
% parm.abs
% parm.normalize
% parm.freq_ave : low pass frequency of moving average [Hz] for 'voice'
% 
% 2009-6-11 Masa-aki Sato
% 2011-12-11 Masa-aki Sato added 'status_out'
% 2012-1-8  Masa-aki Sato  added 't_stay'
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

ix = [];

if isfield(parm,'abs') && parm.abs == 1,
	status = abs(status);
end

if isfield(parm,'t_stay')
	t_stay = parm.t_stay;
else
	t_stay = 10;
end

switch	lower(parm.trig_type)
case	'bit'
%	status_val = 2.^status_level;
	status_val = status_level;
	status_out = status;
	switch	lower(parm.slope)
	case	'low_to_high'
		ix = vb_bit_ptn_start(status,status_val,t_stay);
	case	'high_to_low'
		ix = vb_bit_ptn_end(status,status_val,t_stay);
	end
case	'integer'
	switch	lower(parm.slope)
	case	'const_start'
		ix = vb_event_start(status,status_level,t_stay);
	case	'const_end'
		ix = vb_event_end(status,status_level,t_stay);
	end
	
	status_val = status_level;
	status_out = status;
case	'analog'
	if ~isfield(parm,'normalize') || parm.normalize == 1,
		status_val = status_level * max(status);
	else
		status_val = status_level;
	end
	status_out = status;
	
	switch	lower(parm.slope)
	case	'low_to_high'
		ix = vb_trigger_start(status,status_val);
	case	'high_to_low'
		ix = vb_trigger_end(status,status_val);
	end
case	'voice'
	[ix ,status_val, status_out] = ...
		vb_get_voice_onset(status,status_level,parm);
case	'emg'
	[ix ,status_val, status_out] = vb_get_emg_onset(status,parm);
end
